# Initial value for theta

# poisson fit
quine.po1 <- glm(Days ~ .^4, poisson, quine, trace = T)
summary(quine.po1, cor = F)

t0 <- 1/var(quine$Days/fitted(quine.po1) - 1)
t0

# takes care of overdispersion
# binomial negative fit
quine.nb1 <- glm.nb(Days ~ Eth*Lrn*Age*Sex, data = quine, init.theta = t0, trace = T)

summary(quine.nb1)

# Its an example of confounding situation
quine.nb1$call$trace <- F
dropterm(quine.nb1, test="Chisq")

quine.nb2 <- update(quine.nb1, .~.-Eth:Lrn:Age:Sex)
dropterm(quine.nb2, test = "Chisq", k = log(nrow(quine)))

quine.nb3 <- update(quine.nb2, .~.-Eth:Age:Sex)
dropterm(quine.nb3, test ="Chisq", k = log(nrow(quine)))

quine.nb4 <- update(quine.nb3, .~.-Lrn:Age:Sex)
dropterm(quine.nb4, test ="Chisq", k = log(nrow(quine)))

quine.nb5 <- update(quine.nb4, .~.-Lrn:Age:Eth)
dropterm(quine.nb5, test ="Chisq", k = log(nrow(quine)))

quine.nb6 <- update(quine.nb5, .~.-Lrn:Age)
dropterm(quine.nb6, test ="Chisq", k = log(nrow(quine)))

quine.nb7 <- update(quine.nb6, .~.-Eth:Age)
dropterm(quine.nb7, test ="Chisq", k = log(nrow(quine)))

quine.check <- glm.nb(Days ~ Sex/(Age + Eth*Lrn), quine)

deviance(quine.nb7)
deviance(quine.check)
range(fitted(quine.nb7) - fitted(quine.check))

fv <- fitted(quine.nb7)
rs <- resid(quine.nb7, type = "deviance")
pv <- predict(quine.nb7)

plot(fv, pv)

par(mfrow = c(2,2))
plot(fv, rs, xlab = "fitted values", ylab = "deviance residuals")
abline(h = 0, lty = 4, lwd = 2, col = 3)
qqnorm(rs, ylab = "sorted deviance residuals")
qqline(rs, col = 3, lwd = 2, lty = 4)
par(mfrow=c(1,1))

quine.glm1 <- glm(Days ~ Eth*Sex*Lrn*Age, negative.binomial(theta = t0),
                  quine, trace = F)
quine.step <- stepAIC(quine.glm1, k = log(nrow(quine)), trace = F)
quine.step
dropterm(quine.step, test = "Chisq")


#### poisson log-linear (multinomial) models

names(housing)

hous.glm0 <- glm(Freq ~ Infl*Type*Cont, poisson, housing)
hous.glm1 <- update(hous.glm0, .~.+Sat)
anova(hous.glm0, hous.glm1, test = "Chisq")

addterm(hous.glm1, .~.+Sat*(Infl+Type+Cont), test = "Chisq")

hous.glm2 <- update(hous.glm1, .~.+Sat*(Infl+Type+Cont))


levs <- lapply(housing[, -5], levels)
dlev <- sapply(levs, length)
ind <- do.call("cbind", lapply(housing[, -5],
        function(x) match(x, levels(x))))


RF <- Pr <- array(0, dim = dlev, dimnames = levs)
RF[ind] <- housing$Freq
tots <- rep(apply(RF, 2:4, sum), each = 3)
RF <- RF/as.vector(tots)
RF

Pr[ind] <- fitted(hous.glm2)
Pr <- Pr/as.vector(tots)
Pr

library(nnet)
hous.mult <- multinom(Sat ~ Infl+Type+Cont, data = housing, weights = Freq, trace = T)

round(fitted(hous.mult), 2)

h1 <- t(fitted(hous.mult)[seq(3,72,3), ])
range(h1 - as.vector(Pr))

hous.polr <- polr(Sat ~ Infl+Type+Cont, data = housing, weights = Freq)

plot(fitted(hous.polr), fitted(hous.mult))
abline(0, 1, col=3, lty=4, lwd=1)

hous.polr2 <- stepAIC(hous.polr, ~.^2, k = log(24))
hous.polr2$call$formula
